package book.beans;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.servlet.http.Part;

/**
 *
 * @author Leonard
 */
@Named
@RequestScoped
public class UploadBean {

    private static final Logger logger = Logger.getLogger(UploadBean.class.getName());
    private Part file;

    public Part getFile() {
        return file;
    }

    public void setFile(Part file) {
        this.file = file;
    }

    public void upload() {

        if (file != null) {

            logger.info("Szczegółowe informacje o pliku:");
            logger.log(Level.INFO, "Identyfikator komponentu file:{0}", file.getName());
            logger.log(Level.INFO, "Typ zawartości:{0}", file.getContentType());
            logger.log(Level.INFO, "Nazwa przesłanego pliku:{0}", file.getSubmittedFileName());            
            logger.log(Level.INFO, "Wielkość pliku:{0}", file.getSize());

            try {
                file.write(file.getSubmittedFileName());
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Udało się pomyślnie przesłać plik na serwer!"));
            } catch (IOException e) {
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Nie udało się przesłać pliku!"));
            }
        }
    }
}
